#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
ShellOut.py
Wywołanie programu zewnętrznego przekazuje aktywną warstwę jako plik temp.  
Windows Only(?)

Author:
Rob Antonishen

Wersja:
0.7 naprawiono błąd Zapisu pliku, gdzie wszystkie pliki były png bez względu na rozszerzenie 
0.6 zmodyfikowane, aby zwracać warstwę, która ma inny rozmiar niż zapisana warstwa 
  0.5 parametr rozszerzenie pliku na liście programu.
0.4 zmodyfikowanie do opcjonalnej obsługi wielu programów. 

Ten skrypt jest wzorowany na wtyczce (plugin) mm_extern_LabCurves 
Michael Munzert http://www.mm-log.com/lab-curves-gimp (link już nie działa)

i dzięki gimp-chat nieco rozrosła ;)

License:

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

The GNU Public License is available at
http://www.gnu.org/copyleft/gpl.html

'''

from gimpfu import *
import shlex
import subprocess
import os, sys
import tempfile

# lista funkcji programu (globalne są złe)
def listcommands(option=None):
  #
  # Wstaw dodatkowe polecenia powłoki do tej  listy.  Będą one wyświetlane w tej kolejności w rozwijanym menu.
  # Użyj składni:
  # ["Menu Label - Etykieta Menu", "command", "ext"]
  # 
  # Gdzie i co wykona pobiera polecenie nazwa pliku więc zawiera i flagi potrzebne w poleceniu.
  # Where what gets executed is command fileame so include and flags needed in the command.
  programlist = [
  ["Photivo1", "\"C:\\Program Files\\Photivo\\photivo.exe\" -i", "png"],
  ["Photivo2", "\"C:\\Program Files\\Photivo\\photivo.exe\" -i", "tiff"],
  ["SNS-HDR Pro", "\"C:\\Program Files\\SNS-HDR Pro\\SNS-HDR Pro.exe\"", "tiff"], 
  ["Analog Efex Pro 2", "\"C:\\Program Files\\Google\\Nik Collection\\Analog Efex Pro 2\\Analog Efex Pro 2 (64-Bit)\\Analog Efex Pro 2.exe\"", "jpg"], 
  ["Color Efex Pro 4", "\"C:\\Program Files\\Google\\Nik Collection\\Color Efex Pro 4\\Color Efex Pro 4 (64-Bit)\\Color Efex Pro 4.exe\"", "jpg"],
  ["DFine 2", "\"C:\\Program Files\\Google\\Nik Collection\\Dfine 2\\Dfine 2 (64-Bit)\\Dfine2.exe\"", "png"],
  ["Sharpener Pro 3", "\"C:\\Program Files\\Google\\Nik Collection\\Sharpener Pro 3\\Sharpener Pro 3 (64-Bit)\\SHP3OS.exe\"", "png"],
  ["Silver Efex Pro 2", "\"C:\\Program Files\\Google\\Nik Collection\\Silver Efex Pro 2\\Silver Efex Pro 2 (64-Bit)\\Silver Efex Pro 2.exe\"", "jpg"], 
  ["Viveza 2", "\"C:\\Program Files\\Google\\Nik Collection\\Viveza 2\\Viveza 2 (64-Bit)\\Viveza 2.exe\"", "png"],
  ["CMYKTool_jpg", "\"C:\\CMYKTool Standalone PL\\CMYKTool\\cmyktool.exe\"", "jpg"],
  ["CMYKTool_tiff", "\"C:\\CMYKTool Standalone PL\\CMYKTool\\cmyktool.exe\"", "tiff"],
  #["MS Paint", "\"C:\\WINDOWS\\system32\\mspaint.exe\"", "png"],
  #["Helicon Filter", "\"C:\\Program Files (x86)\\Helicon Software\\Helicon Filter\\HeliconFilter.exe\"", "tiff"],
  #["XNView", "\"C:\\PF\\XnView\\xnview.exe\"", "png"],
  #["Inkscape", "\"C:\\Program Files\\Inkscape\\inkscape.exe\"", "png"],
  #["PaintDOTNet", "\"C:\\Program Files\\Paint.NET\\PaintDotNet.exe\"", "png"],
  #["MyPaint", "\"C:\\Program Files\\MyPaint\\mypaint.exe\"", "png"],
  #["Photo Filter Factory", "\"C:\\Program Files\\Photo Filter Factory\\Photo Filter Factory.exe\"", "png"],
  #["Photo Pos Pro", "\"C:\\Program Files\\Photo Pos Pro\\Photo Pos Pro.exe\"", "png"],
  #["Java Image Editor", "\"C:\\JavaJars\\imageeditor.bat\"", "png"],
  #["Java Mosaic", "\"C:\\JavaJars\\mosaic.bat\"", "png"],
  #["JDraw", "\"C:\\JavaJars\\jdraw.bat\"", "png"],
  #["Vector Magic", "\"C:\\Program Files\\Vector Magic\\vmde.exe\"", "png"],
  #["Photo Clinic", "\"C:\\MAGIX\\Photo_Clinic_45\\PhotoClinic.exe\"", "png"],
  #["Smilla Enlarger", "\"F:\Instal\Grafika\SmillaEnlarger-0.9.0\SmillaEnlarger-0.9.0\SmillaEnlarger\SmillaEnlarger.exe\"", "png"],
  ]
  
  if option == None: # no parameter return menu list, otherwise return the appropriate array
    menulist = []
    for i in programlist:
      if i[0] != "":
        menulist.append(i[0])
    return menulist
  else:
    return programlist[option]
	

def plugin_main(image, drawable, visible, command):
  pdb.gimp_image_undo_group_start(image)
  
  # Kopiuj i zapisz operacje nie wpływają na oryginał.  
  # Copy so the save operations doesn't affect the original
  if visible == 0:
    # Zapisz w temp. Uwaga: użytkownik usuwa wprowadzoną nazwę pliku
	# Save in temporary.  Note: empty user entered file name
    temp = pdb.gimp_image_get_active_drawable(image)
  else:
    # Pobierz aktualnie visible (widoczne)
	# Get the current visible
    temp = pdb.gimp_layer_new_from_visible(image, image, "Visible")
    image.add_layer(temp, 0)

  buffer = pdb.gimp_edit_named_copy(temp, "ShellOutTemp")

  # zapisać zaznaczenie jeśli istnieje
  # save selection if one exists
  hassel = pdb.gimp_selection_is_empty(image) == 0
  if hassel:
    savedsel = pdb.gimp_selection_save(image)

  tempimage = pdb.gimp_edit_named_paste_as_new(buffer)
  pdb.gimp_buffer_delete(buffer)
  if not tempimage:
    raise RuntimeError
  pdb.gimp_image_undo_disable(tempimage)

  tempdrawable = pdb.gimp_image_get_active_layer(tempimage)
  
  # pobierz program do uruchomienia i typ pliku
  # get the program to run and filetype.
  progtorun = listcommands(command)
  
  # Użyj nazwy pliku temp GIMP-a, pokazuje on użytkownikowi wyjście w gimprc
  # wskazane, jeśli chcesz zawsze używać tej samej nazwy pliku temp
  # tempfilename = pdb.gimp_temp_name(progtorun[2])
  
  # Use temp file names from gimp, it reflects the user's choices in gimp.rc
  # change as indicated if you always want to use the same temp file name
  # tempfilename = pdb.gimp_temp_name(progtorun[2])
  tempfilename = os.path.join(tempfile.gettempdir(), "ShellOutTempFile."+progtorun[2])
  

  # !!! Uwaga brak pierwszy parametr, i wprowadzone przez użytkownika nazwa pliku jest ciąg pusty 
  # !!! Note no run-mode first parameter, and user entered filename is empty string
  pdb.gimp_progress_set_text ("Saving a copy")
  pdb.gimp_file_save(tempimage, tempdrawable, tempfilename, tempfilename)

  # Budowanie wiersza poleceń wywołania
  # Build command line call
  command = progtorun[1] + " \"" + tempfilename + "\""
  args = shlex.split(command)

  # Wywołaj polecenie zewnętrzne
  # Invoke external command
  pdb.gimp_progress_set_text ("calling " + progtorun[0] + "...")
  pdb.gimp_progress_pulse()
  child = subprocess.Popen(args, shell=False)
  child.communicate()

  # umieścić go jako nową warstwę w otwartym obrazie
  # put it as a new layer in the opened image
  try:
    newlayer2 = pdb.gimp_file_load_layer(tempimage, tempfilename)
  except:
    RuntimeError
	
  tempimage.add_layer(newlayer2,-1)
  buffer = pdb.gimp_edit_named_copy(newlayer2, "ShellOutTemp")

  if visible == 0:
    drawable.resize(newlayer2.width,newlayer2.height,0,0)
    sel = pdb.gimp_edit_named_paste(drawable, buffer, 1)
    drawable.translate((tempdrawable.width-newlayer2.width)/2,(tempdrawable.height-newlayer2.height)/2)
  else:
    temp.resize(newlayer2.width,newlayer2.height,0,0)
    sel = pdb.gimp_edit_named_paste(temp, buffer, 1)
    temp.translate((tempdrawable.width-newlayer2.width)/2,(tempdrawable.height-newlayer2.height)/2)

  pdb.gimp_buffer_delete(buffer)
  pdb.gimp_edit_clear(temp)	
  pdb.gimp_floating_sel_anchor(sel)

  # załadować stare zaznaczenie
  # load up old selection
  if hassel:
    pdb.gimp_selection_load(savedsel)  # 'gimp-image-select-item'
    image.remove_channel(savedsel)
  
  # Wyczyść
  # cleanup
  os.remove(tempfilename)  # usunąć plik tymczasowy  delete the temporary file
  gimp.delete(tempimage)   # usunąć tymczasowy obraz  delete the temporary image

  # Uwaga nowy obraz będzie w GIMP brzydki, a użytkownik zostanie poproszony, aby zapisać przed zamknięciem.
  # Note the new image is dirty in Gimp and the user will be asked to save before closing.
  pdb.gimp_image_undo_group_end(image)
  gimp.displays_flush()


register(
        "python_fu_shellout",
        "Wywołanie zewnętrznego programu ",
        "Wywołanie zewnętrznego programu ",
        "Rob Antonishen",
        "Copyright 2011 Rob Antonishen",
        "2011",
        "<Image>/Filters/ShellOut...",
        "RGB*, GRAY*", 
        [ (PF_RADIO, "visible", "Warstwa:", 1, (("na nowej warstwie", 1),("na bieżącej warstwie",0))),
          (PF_OPTION,"command",("Program:"),0,listcommands())
        ],
        [],
        plugin_main,
        )

main()